/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.Foreign;
import com.kenai.jffi.MemoryIO;
import com.kenai.jffi.NativeMethod;
import com.kenai.jffi.Platform;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NativeMethods {
    private static final Map<Class, NativeMethods> registeredMethods = new WeakHashMap<Class, NativeMethods>();
    private final long memory;
    private final List<NativeMethod> methods;

    private NativeMethods(long l, List<NativeMethod> list) {
        this.memory = l;
        this.methods = new ArrayList<NativeMethod>(list);
    }

    public static final synchronized void register(Class clazz, List<NativeMethod> list) {
        long l = Platform.getPlatform().addressSize() / 8;
        MemoryIO memoryIO = MemoryIO.getInstance();
        long l2 = memoryIO.allocateMemory((long)(list.size() * 3) * l, true);
        if (l2 == 0L) {
            throw new OutOfMemoryError("could not allocate native memory");
        }
        NativeMethods nativeMethods = new NativeMethods(l2, list);
        long l3 = 0L;
        for (NativeMethod nativeMethod : list) {
            memoryIO.putAddress(l2 + l3, nativeMethod.name);
            memoryIO.putAddress(l2 + (l3 += l), nativeMethod.signature);
            memoryIO.putAddress(l2 + (l3 += l), nativeMethod.function);
            l3 += l;
        }
        if (Foreign.getInstance().registerNatives(clazz, l2, list.size()) != 0) {
            throw new RuntimeException("failed to register native methods");
        }
        registeredMethods.put(clazz, nativeMethods);
    }

    public static final synchronized void unregister(Class clazz) {
        if (!registeredMethods.containsKey(clazz)) {
            throw new IllegalArgumentException("methods were not registered on class via NativeMethods.register");
        }
        if (Foreign.getInstance().unregisterNatives(clazz) != 0) {
            throw new RuntimeException("failed to unregister native methods");
        }
        registeredMethods.remove(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            MemoryIO.getInstance().freeMemory(this.memory);
        }
        finally {
            super.finalize();
        }
    }
}

